/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.buildsupport;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.spockframework.buildsupport.SpecClassFileVisitor;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.ReflectionUtil;

class AsmClassReader {
    private static final Method acceptMethod;
    private static final Object acceptMethodSecondArg;
    private final ClassReader reader;

    AsmClassReader(InputStream stream) throws IOException {
        this.reader = new ClassReader(stream);
    }

    void accept(SpecClassFileVisitor visitor) {
        ReflectionUtil.invokeMethod(this.reader, acceptMethod, new Object[]{visitor, acceptMethodSecondArg});
    }

    static {
        Method m = ReflectionUtil.getMethodBySignature(ClassReader.class, "accept", ClassVisitor.class, Boolean.TYPE);
        Comparable<Boolean> arg = true;
        if (m == null) {
            m = ReflectionUtil.getMethodBySignature(ClassReader.class, "accept", ClassVisitor.class, Integer.TYPE);
            arg = 7;
        }
        if (m == null) {
            throw new InternalSpockError("failed to find method org.objectweb.asm.ClassReader.accept(); seems like an incompatible version of ASM is on the class path");
        }
        acceptMethod = m;
        acceptMethodSecondArg = arg;
    }
}

