#include "translate.h"

/* table from Linux kernel */
static const t_unicode vt100_g0_chars[] = {
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, /* 0x20-0x27 */
0x0028, 0x0029, 0x002a, 0x2192, 0x2190, 0x2191, 0x2193, 0x002f, /* 0x28-0x2F */
0x2588, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, /* 0x30-0x37 */
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, /* 0x38-0x3F */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, /* 0x40-0x47 */
0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, /* 0x48-0x4F */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, /* 0x50-0x57 */
0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x00a0, /* 0x58-0x5F */
0x25c6, 0x2592, 0x2409, 0x240c, 0x240d, 0x240a, 0x00b0, 0x00b1, /* 0x60-0x67 */
0x2591, 0x240b, 0x2518, 0x2510, 0x250c, 0x2514, 0x253c, 0xf800, /* 0x68-0x6F */
0xf801, 0x2500, 0xf803, 0xf804, 0x251c, 0x2524, 0x2534, 0x252c, /* 0x70-0x77 */
0x2502, 0x2264, 0x2265, 0x03c0, 0x2260, 0x00a3, 0x00b7, 0x007f, /* 0x78-0x7F */
};

struct char_set vt100_g0 = {
	1,
	CHARS(vt100_g0_chars),
	0, "", 0, 96,
};

struct char_set vt100 = {
	.c0 = &ascii_c0,
	.g0 = &vt100_g0,
	.names = { "vt100", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&vt100_g0);
	register_charset(&vt100);
}
