/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.PrologImplementationPeer;
import com.declarativa.interprolog.PrologOperatorsContext;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.Recognizer;
import java.io.File;
import java.util.Properties;

public class XSBPeer
extends PrologImplementationPeer {
    public XSBPeer(AbstractPrologEngine abstractPrologEngine) {
        super(abstractPrologEngine);
        this.operators = new PrologOperatorsContext(PrologOperatorsContext.standardXSBOperators);
        this.systemName = "XSB Prolog";
    }

    public String getBinDirectoryProperty(Properties properties) {
        return properties.getProperty("XSB_BIN_DIRECTORY");
    }

    public String executablePath(String string) {
        return String.valueOf(string) + File.separator + "xsb";
    }

    protected String fetchPrologNumericVersion() {
        Object[] objectArray = this.engine.deterministicGoal("xsb_configuration(version,V)", "[string(V)]");
        return (String)objectArray[0];
    }

    public String[] alternativePrologExtensions(String string) {
        if (string.indexOf(46) != -1) {
            throw new IPException("Bad use of alternativePrologExtensions");
        }
        if (this.xsbUsesXwamExtension()) {
            return new String[]{String.valueOf(string) + ".xwam", String.valueOf(string) + ".P"};
        }
        return new String[]{String.valueOf(string) + ".O", String.valueOf(string) + ".P"};
    }

    private boolean xsbUsesXwamExtension() {
        String string = this.engine.getPrologBaseDirectory();
        String string2 = String.valueOf(string) + File.separator + "cmplib" + File.separator + "compile";
        if (new File(String.valueOf(string2) + ".xwam").exists()) {
            return true;
        }
        if (new File(String.valueOf(string2) + ".O").exists()) {
            return false;
        }
        throw new IPException("Weird XSB Prolog installation, could find neither compile.O nor compile.xwam in cmplib:" + string2);
    }

    public String prologBinToBaseDirectory(String string) {
        int n = (string = string.trim()).lastIndexOf(String.valueOf(File.separator) + "config" + File.separator);
        if (n == -1) {
            throw new IPException("Can not determine base directory, missing config in known path!");
        }
        if ((string = string.substring(0, n)).endsWith(File.separator)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Recognizer makePromptRecognizer() {
        return new Recognizer("| ?-");
    }

    public Recognizer makeBreakRecognizer() {
        return new Recognizer(": ?-");
    }

    public String interprologFilename() {
        return "xsb/interprolog";
    }

    public String visualizationFilename() {
        return "visualization";
    }

    public boolean isInterrupt(Object object) {
        return object.toString().startsWith("Aborting");
    }
}

