/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.NonNullApi;
import org.gradle.api.problems.internal.ExceptionProblemRegistry;
import org.gradle.api.problems.internal.ProblemLookup;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.logging.LoggingBuildOperationProgressBroadcaster;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.launcher.exec.RunBuildBuildOperationType;

@NonNullApi
public class RunAsBuildOperationBuildActionExecutor
implements BuildSessionActionExecutor {
    private static final RunBuildBuildOperationType.Result RESULT = new RunBuildBuildOperationType.Result(){};
    private final BuildSessionActionExecutor delegate;
    private final BuildOperationRunner buildOperationRunner;
    private final LoggingBuildOperationProgressBroadcaster loggingBuildOperationProgressBroadcaster;
    private final BuildOperationNotificationValve buildOperationNotificationValve;
    private final ExceptionProblemRegistry problemContainer;

    public RunAsBuildOperationBuildActionExecutor(BuildSessionActionExecutor delegate, BuildOperationRunner buildOperationRunner, LoggingBuildOperationProgressBroadcaster loggingBuildOperationProgressBroadcaster, BuildOperationNotificationValve buildOperationNotificationValve, ExceptionProblemRegistry problemContainer) {
        this.delegate = delegate;
        this.buildOperationRunner = buildOperationRunner;
        this.loggingBuildOperationProgressBroadcaster = loggingBuildOperationProgressBroadcaster;
        this.buildOperationNotificationValve = buildOperationNotificationValve;
        this.problemContainer = problemContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result execute(final BuildAction action, final BuildSessionContext context) {
        this.buildOperationNotificationValve.start();
        try {
            BuildActionRunner.Result result = (BuildActionRunner.Result)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<BuildActionRunner.Result>(){

                public BuildActionRunner.Result call(BuildOperationContext buildOperationContext) {
                    RunAsBuildOperationBuildActionExecutor.this.loggingBuildOperationProgressBroadcaster.rootBuildOperationStarted();
                    BuildActionRunner.Result result = RunAsBuildOperationBuildActionExecutor.this.delegate.execute(action, context);
                    buildOperationContext.setResult((Object)RESULT);
                    if (result.getBuildFailure() != null) {
                        buildOperationContext.failed(result.getBuildFailure());
                    }
                    return result;
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Run build").details((Object)new RunBuildBuildOperationType.Details(){

                        @Override
                        public ProblemLookup getProblemLookup() {
                            return RunAsBuildOperationBuildActionExecutor.this.problemContainer.getProblemLookup();
                        }
                    });
                }
            });
            return result;
        }
        finally {
            this.buildOperationNotificationValve.stop();
        }
    }
}

