/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.io.File;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class LoadGameCommand
extends ServerCommand {
    public LoadGameCommand(Server server) {
        super(server, "load", "load a saved game from the savegames directory.  Usage: /load [filename]");
    }

    public void run(int n, String[] stringArray) {
        if (!this.canRunRestrictedCommand(n)) {
            this.server.sendServerChat(n, "Observers are restricted from loading games.");
            return;
        }
        if (stringArray.length > 1) {
            this.load(new File("savegames", stringArray[1]), n);
        } else {
            this.server.sendServerChat(n, "you must provide a file name");
        }
    }

    private void load(File file, int n) {
        this.server.sendServerChat(this.server.getPlayer(n).getName() + " loaded a new game.");
        if (this.server.loadGame(file)) {
            this.server.resetConnections();
        } else {
            this.server.sendServerChat(file.getName() + " could not be loaded");
        }
    }
}

