/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import megamek.client.Client;
import megamek.client.bot.BotClient;
import megamek.client.bot.TestBot;
import megamek.client.bot.ui.AWT.BotGUI;
import megamek.common.Player;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class AddBotCommand
extends ServerCommand {
    public AddBotCommand(Server server) {
        super(server, "replacePlayer", "Replaces a player who is a ghost with a bot. Usage /replacePlayer name, to replace the player named name. they must be a ghost.");
    }

    public void run(int n, String[] stringArray) {
        if (stringArray.length < 2) {
            this.server.sendServerChat(n, "You must specify a player name.");
            return;
        }
        String string = stringArray[1];
        for (int i = 2; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        Player player = null;
        Object object = this.server.getGame().getPlayers();
        while (object.hasMoreElements()) {
            Player player2 = object.nextElement();
            if (!player2.getName().equals(string)) continue;
            player = player2;
        }
        if (player == null) {
            this.server.sendServerChat(n, "No player with the name '" + stringArray[1] + "'.");
            return;
        }
        if (player.isGhost()) {
            object = new TestBot(player.getName(), this.server.getHost(), this.server.getPort());
            ((BotClient)object).game.addGameListener(new BotGUI((BotClient)object));
            try {
                ((Client)object).connect();
            }
            catch (Exception exception) {
                this.server.sendServerChat(n, "Bot failed to connect.");
            }
            ((BotClient)object).retrieveServerInfo();
            this.server.sendServerChat("Bot has replaced " + player.getName() + ".");
            return;
        }
        this.server.sendServerChat(n, "Player " + player.getName() + " is not a ghost.");
    }
}

