/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Report;
import megamek.common.Terrains;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuicksandProcessor
extends DynamicTerrainProcessor {
    private IGame game;
    Vector<Report> vPhaseReport;

    public QuicksandProcessor(Server server) {
        super(server);
    }

    @Override
    void doEndPhaseChanges(Vector<Report> vector) {
        this.game = this.server.getGame();
        this.vPhaseReport = vector;
        this.resolveQuicksand();
        this.vPhaseReport = null;
    }

    private void debugTime(String string, boolean bl) {
    }

    private void resolveQuicksand() {
        IBoard iBoard = this.game.getBoard();
        int n = iBoard.getWidth();
        int n2 = iBoard.getHeight();
        this.debugTime("resolve quicksand 1", true);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Coords coords = new Coords(i, j);
                IHex iHex = iBoard.getHex(i, j);
                if (iHex.terrainLevel(14) == 3) {
                    Enumeration<Entity> enumeration = this.game.getEntities(coords);
                    while (enumeration.hasMoreElements()) {
                        Entity entity = enumeration.nextElement();
                        if (!entity.isStuck()) continue;
                        this.server.doSinkEntity(entity);
                    }
                    continue;
                }
                if (iHex.terrainLevel(14) != 2) continue;
                iHex.removeTerrain(14);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(14, 3));
                this.server.sendChangedHex(coords);
            }
        }
        this.debugTime("resolve quicksand 1 end", true);
    }
}

