/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.CapitalMissileWeapon;
import megamek.common.weapons.WhiteSharkHandler;
import megamek.common.weapons.WhiteSharkTHandler;
import megamek.server.Server;

public class WhiteSharkTWeapon
extends CapitalMissileWeapon {
    private static final long serialVersionUID = 8756042527483383101L;

    public WhiteSharkTWeapon() {
        this.techLevel = 1;
        this.name = "White Shark-T";
        this.setInternalName(this.name);
        this.addLookupName("WhiteSharkT");
        this.heat = 15;
        this.damage = 3;
        this.ammoType = 58;
        this.shortRange = 12;
        this.mediumRange = 24;
        this.longRange = 36;
        this.extremeRange = 48;
        this.tonnage = 130.0f;
        this.bv = 692.0;
        this.cost = 145000.0;
        this.shortAV = 3.0;
        this.medAV = 3.0;
        this.longAV = 3.0;
        this.extAV = 3.0;
        this.maxRange = 4;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.hasFlag(1024L)) {
            return new WhiteSharkTHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new WhiteSharkHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

