/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMSimplePolygonArea;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.client.ui.swing.widget.WidgetUtils;
import megamek.common.Aero;
import megamek.common.Entity;
import megamek.common.SmallCraft;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AeroMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private JComponent comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[5];
    private PMSimpleLabel[] labels = new PMSimpleLabel[11];
    private PMValueLabel[] vLabels = new PMValueLabel[11];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private Polygon noseArmor = new Polygon(new int[]{45, 50, 60, 65, 75, 80}, new int[]{80, 20, 0, 0, 20, 80}, 6);
    private Polygon Structure = new Polygon(new int[]{50, 50, 75, 75}, new int[]{80, 160, 160, 80}, 4);
    private Polygon leftWingArmor = new Polygon(new int[]{50, 45, 0, 0, 45, 50}, new int[]{80, 80, 140, 180, 160, 160}, 6);
    private Polygon rightWingArmor = new Polygon(new int[]{75, 80, 125, 125, 80, 75}, new int[]{80, 80, 140, 180, 160, 160}, 6);
    private Polygon aftArmor = new Polygon(new int[]{45, 45, 30, 30, 95, 95, 80, 80}, new int[]{160, 180, 190, 200, 200, 190, 180, 160}, 8);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public AeroMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        Aero aero = (Aero)entity;
        int n = 1;
        int n2 = 1;
        for (int i = 0; i < aero.locations(); ++i) {
            n = aero.getArmor(i);
            n2 = aero.getOArmor(i);
            this.vLabels[i].setValue(aero.getArmorString(i));
            WidgetUtils.setAreaColor(this.areas[i], this.vLabels[i], (double)n / (double)n2);
        }
        n = aero.getSI();
        n2 = aero.get0SI();
        this.vLabels[4].setValue(Integer.toString(aero.getSI()));
        WidgetUtils.setAreaColor(this.areas[4], this.vLabels[4], (double)n / (double)n2);
        this.vLabels[5].setValue(this.getCriticalHitTally(aero.getAvionicsHits(), 3));
        this.vLabels[6].setValue(this.getCriticalHitTally(aero.getEngineHits(), aero.getMaxEngineHits()));
        this.vLabels[7].setValue(this.getCriticalHitTally(aero.getFCSHits(), 3));
        this.vLabels[8].setValue(this.getCriticalHitTally(aero.getSensorHits(), 3));
        if (aero instanceof SmallCraft) {
            SmallCraft smallCraft = (SmallCraft)aero;
            this.vLabels[9].setValue(this.getCriticalHitTally(smallCraft.getLeftThrustHits(), 3));
            this.vLabels[10].setValue(this.getCriticalHitTally(smallCraft.getRightThrustHits(), 3));
        } else {
            this.vLabels[9].setValue("-");
            this.vLabels[10].setValue("-");
        }
    }

    private void setContent() {
        for (int i = 0; i < 4; ++i) {
            this.content.addArea(this.areas[i]);
            this.content.addArea(this.labels[i]);
            this.content.addArea(this.vLabels[i]);
        }
        this.content.addArea(this.areas[4]);
        this.content.addArea(this.labels[4]);
        this.content.addArea(this.vLabels[4]);
        this.content.addArea(this.labels[5]);
        this.content.addArea(this.vLabels[5]);
        this.content.addArea(this.labels[6]);
        this.content.addArea(this.vLabels[6]);
        this.content.addArea(this.labels[7]);
        this.content.addArea(this.vLabels[7]);
        this.content.addArea(this.labels[8]);
        this.content.addArea(this.vLabels[8]);
        this.content.addArea(this.labels[9]);
        this.content.addArea(this.vLabels[9]);
        this.content.addArea(this.labels[10]);
        this.content.addArea(this.vLabels[10]);
    }

    private void setAreas() {
        this.areas[0] = new PMSimplePolygonArea(this.noseArmor);
        this.areas[2] = new PMSimplePolygonArea(this.rightWingArmor);
        this.areas[1] = new PMSimplePolygonArea(this.leftWingArmor);
        this.areas[3] = new PMSimplePolygonArea(this.aftArmor);
        this.areas[4] = new PMSimplePolygonArea(this.Structure);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[0] = WidgetUtils.createLabel("NOS", fontMetrics, Color.black, 62, 30);
        this.labels[1] = WidgetUtils.createLabel("LWG", fontMetrics, Color.black, 32, 120);
        this.labels[2] = WidgetUtils.createLabel("RWG", fontMetrics, Color.black, 92, 120);
        this.labels[3] = WidgetUtils.createLabel("AFT", fontMetrics, Color.black, 62, 170);
        this.labels[4] = WidgetUtils.createLabel("SI", fontMetrics, Color.black, 62, 120);
        this.labels[5] = WidgetUtils.createLabel("Avionics:", fontMetrics, Color.white, 10, 210);
        this.labels[6] = WidgetUtils.createLabel("Engine:", fontMetrics, Color.white, 10, 225);
        this.labels[7] = WidgetUtils.createLabel("FCS:", fontMetrics, Color.white, 10, 240);
        this.labels[8] = WidgetUtils.createLabel("Sensors:", fontMetrics, Color.white, 10, 255);
        this.labels[9] = WidgetUtils.createLabel("L Thrust:", fontMetrics, Color.white, 90, 210);
        this.labels[10] = WidgetUtils.createLabel("R Thrust:", fontMetrics, Color.white, 90, 225);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[0] = WidgetUtils.createValueLabel(62, 45, "", fontMetrics);
        this.vLabels[1] = WidgetUtils.createValueLabel(32, 135, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(92, 135, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(62, 185, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(62, 135, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(40, 210, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(40, 225, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(40, 240, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(40, 255, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(130, 210, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(130, 225, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
        this.areas[0].translate(0, 0);
        this.areas[1].translate(0, 0);
        this.areas[2].translate(0, 0);
        this.areas[3].translate(0, 0);
        this.areas[4].translate(0, 0);
    }

    private String getCriticalHitTally(int n, int n2) {
        String string = "";
        if (n < 1) {
            return string;
        }
        if (n >= n2) {
            string = "Out";
            return string;
        }
        while (n > 0) {
            string = string + "X";
            --n;
        }
        return string;
    }
}

