/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsic;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public class CompanionObjectIntrinsicAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final JsExpression referenceToCompanionObject;

    @NotNull
    static CompanionObjectIntrinsicAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression2);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression2.getText();
        return new CompanionObjectIntrinsicAccessTranslator(referenceDescriptor, context);
    }

    static boolean isCompanionObjectReference(@NotNull KtReferenceExpression expression2, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression2);
        return descriptor2 instanceof ClassDescriptor && context.intrinsics().getObjectIntrinsic((ClassDescriptor)descriptor2) != null;
    }

    private CompanionObjectIntrinsicAccessTranslator(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        super(context);
        this.referenceToCompanionObject = CompanionObjectIntrinsicAccessTranslator.generateReferenceToCompanionObject(descriptor2, context);
    }

    @NotNull
    private static JsExpression generateReferenceToCompanionObject(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        ObjectIntrinsic objectIntrinsic = context.intrinsics().getObjectIntrinsic((ClassDescriptor)descriptor2);
        return objectIntrinsic.apply(context);
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.referenceToCompanionObject;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        throw new IllegalStateException("companion object can't be set");
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        return this;
    }
}

