/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state.mirror;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.mirror.RelativePathSegmentsTracker;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;

public class MerkleDirectorySnapshotBuilder
implements PhysicalSnapshotVisitor {
    private static final HashCode DIR_SIGNATURE = Hashing.md5().hashString((CharSequence)"DIR");
    private final RelativePathSegmentsTracker relativePathSegmentsTracker = new RelativePathSegmentsTracker();
    private final Deque<List<PhysicalSnapshot>> levelHolder = new ArrayDeque<List<PhysicalSnapshot>>();
    private final Deque<String> directoryAbsolutePaths = new ArrayDeque<String>();
    private final boolean sortingRequired;
    private PhysicalSnapshot result;

    public static MerkleDirectorySnapshotBuilder sortingRequired() {
        return new MerkleDirectorySnapshotBuilder(true);
    }

    public static MerkleDirectorySnapshotBuilder noSortingRequired() {
        return new MerkleDirectorySnapshotBuilder(false);
    }

    private MerkleDirectorySnapshotBuilder(boolean sortingRequired) {
        this.sortingRequired = sortingRequired;
    }

    public boolean preVisitDirectory(String absolutePath, String name) {
        this.relativePathSegmentsTracker.enter(name);
        this.levelHolder.addLast(new ArrayList());
        this.directoryAbsolutePaths.addLast(absolutePath);
        return true;
    }

    @Override
    public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
        return this.preVisitDirectory(directorySnapshot.getAbsolutePath(), directorySnapshot.getName());
    }

    @Override
    public void visit(PhysicalSnapshot fileSnapshot) {
        if (this.relativePathSegmentsTracker.isRoot()) {
            this.result = fileSnapshot;
        } else {
            this.levelHolder.peekLast().add(fileSnapshot);
        }
    }

    @Override
    public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
        this.postVisitDirectory(true);
    }

    public void postVisitDirectory() {
        this.postVisitDirectory(true);
    }

    public boolean postVisitDirectory(boolean includeEmpty) {
        String name = this.relativePathSegmentsTracker.leave();
        List<PhysicalSnapshot> children = this.levelHolder.removeLast();
        String absolutePath = this.directoryAbsolutePaths.removeLast();
        if (children.isEmpty() && !includeEmpty) {
            return false;
        }
        if (this.sortingRequired) {
            Collections.sort(children, PhysicalSnapshot.BY_NAME);
        }
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putHash(DIR_SIGNATURE);
        for (PhysicalSnapshot child : children) {
            hasher.putString((CharSequence)child.getName());
            hasher.putHash(child.getHash());
        }
        PhysicalDirectorySnapshot directorySnapshot = new PhysicalDirectorySnapshot(absolutePath, name, children, hasher.hash());
        List<PhysicalSnapshot> siblings = this.levelHolder.peekLast();
        if (siblings != null) {
            siblings.add(directorySnapshot);
        } else {
            this.result = directorySnapshot;
        }
        return true;
    }

    public boolean isRoot() {
        return this.relativePathSegmentsTracker.isRoot();
    }

    public Iterable<String> getRelativePath() {
        return this.relativePathSegmentsTracker.getRelativePath();
    }

    @Nullable
    public PhysicalSnapshot getResult() {
        return this.result;
    }
}

